<?php
/**
 * Transfer Ruud
 * https://webenginecms.org/
 * 
 * @version 1.1.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2021 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

function saveChanges() {
    global $_POST;
	
    $xmlPath = __PATH_TRANSFERRUUD_ROOT__.'config.xml';
    $xml = simplexml_load_file($xmlPath);
	
	
	if(!check_value($_POST['setting_1'])) throw new Exception('Submitted setting is not valid (enable_transfer_tax)');
	if(!in_array($_POST['setting_1'], array(0, 1))) throw new Exception('Submitted setting is not valid (enable_transfer_tax)');
	$xml->enable_transfer_tax = $_POST['setting_1'];
	
	if(!Validator::UnsignedNumber($_POST['setting_2'])) throw new Exception('Submitted setting is not valid (transfer_tax)');
	$xml->transfer_tax = $_POST['setting_2'];
	
	if(!Validator::UnsignedNumber($_POST['setting_3'])) throw new Exception('Submitted setting is not valid (credit_configs)');
	$xml->credit_config = $_POST['setting_3'];
	
	if(!Validator::UnsignedNumber($_POST['setting_4'])) throw new Exception('Submitted setting is not valid (transfer_minimum_limit)');
	$xml->transfer_minimum_limit = $_POST['setting_4'];
	
	if(!Validator::UnsignedNumber($_POST['setting_5'])) throw new Exception('Submitted setting is not valid (transfer_maximum_limit)');
	$xml->transfer_maximum_limit = $_POST['setting_5'];
	
	
    $save = @$xml->asXML($xmlPath);
	if(!$save) throw new Exception('There has been an error while saving changes.');
}

if(check_value($_POST['submit_changes'])) {
	try {
		saveChanges();
		message('success', 'Settings successfully saved.');
	} catch (Exception $ex) {
		message('error', $ex->getMessage());
	}
}

if(check_value($_GET['checkusercplinks'])) {
	try {
		$TransferRuud = new \Plugin\TransferRuud\TransferRuud();
		$TransferRuud->checkPluginUsercpLinks();
		message('success', 'UserCP Links Successfully Added!');
	} catch (Exception $ex) {
		message('error', $ex->getMessage());
	}
}

// load configs
$pluginConfig = simplexml_load_file(__PATH_TRANSFERRUUD_ROOT__.'config.xml');
if(!$pluginConfig) throw new Exception('Error loading config file.');

// credit system
$creditSystem = new CreditSystem();
?>
<h2>Transfer Ruud Settings</h2>
<form action="" method="post">

	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
            <th>Transfer Tax<br/><span>If enabled, the configured transfer tax percent fee will be added to the sender.</span></th>
            <td>
                <?php enabledisableCheckboxes('setting_1', $pluginConfig->enable_transfer_tax, 'Enabled', 'Disabled'); ?>
            </td>
        </tr>
        <tr>
            <th>Transfer Tax Percent<br/><span>If transfer tax is enabled, please set the fee percent for each transfer.</span></th>
            <td>
				<div class="input-group">
					<input class="form-control" type="text" name="setting_2" value="<?php echo $pluginConfig->transfer_tax; ?>"/>
					<div class="input-group-addon">%</div>
				</div>
            </td>
        </tr>
		<tr>
            <th>Ruud Credit Configuration<br/><span>Select the Ruud Credit System Configuration. If not in the list please add with the following information: <br /><br />
			<strong>Title:</strong>Ruud<br />
			<strong>Database:</strong>MuOnline<br />
			<strong>Table:</strong>Character<br />
			<strong>Credits Column:</strong>Ruud<br />
			<strong>User Column:</strong>Name<br />
			<strong>User Identifier:</strong>Character Name<br />
			<strong>Check Online Status:</strong>No<br />
			<strong>Display in My Account:</strong>No
			</span>
			</th>
            <td>
                <?php echo $creditSystem->buildSelectInput('setting_3', $pluginConfig->credit_config, 'form-control'); ?>
            </td>
        </tr>
		<tr>
            <th>Transfer Minimum Limit<br/><span>Minimum amount of Ruud to transfer.</span></th>
            <td>
				<input class="form-control" type="text" name="setting_4" value="<?php echo $pluginConfig->transfer_minimum_limit; ?>"/>
            </td>
        </tr>
		<tr>
            <th>Transfer Maximum Limit<br/><span>Maximum amount of Ruud to transfer.</span></th>
            <td>
				<input class="form-control" type="text" name="setting_5" value="<?php echo $pluginConfig->transfer_maximum_limit; ?>"/>
            </td>
        </tr>
		<tr>
            <td colspan="2"><input type="submit" name="submit_changes" value="Save Changes" class="btn btn-success"/></td>
        </tr>
    </table>
</form>

<h2>UserCP Links</h2>
<p>Click the button below to automatically add the plugin's links to the user control panel menu.</p>
<a href="<?php echo admincp_base('transferruud&page=settings&checkusercplinks=1'); ?>" class="btn btn-primary">Add UserCP Links</a>